#!/bin/bash
if [ -f "LDA_setup_date.txt" ]
then
    rundate=$(<LDA_setup_date.txt)
    # Install the LDA Python extension and upgrade it if necessary
    sudo pip3 install . --upgrade

else
    # Let's remember that we've already done this
    date > LDA_setup_date.txt
    # Get the basic building tools if they aren't here already
    sudo apt-get install -y build-essential
    # We probably already have Python 3, but we'll make sure
    sudo apt-get install -y python3
    sudo apt-get upgrade -y python3
    # And get the dev tools for it
    sudo apt-get install -y python3.6-dev
    # This will install the LDA Ethernet SDK
	sudo dpkg -i ldasdk_0.0.5_amd64.deb

    # Install the LDA Python extension and upgrade it if necessary
    sudo pip3 install . --upgrade

    #
    # Alternatively you can play with the test program interactively
    #   in IDLE. Once it starts, use File->Open to open 'LDA_test.py'
    #sudo idle3
    echo "Don't forget to use 'sudo' when you run Python."
    echo "'sudo python3 LDA_test.py' runs the sample test program."
    echo "'sudo idle3' brings up the interactive IDLE environment."
fi
